//
//  ComplicationDataSource.swift
//  AirAber
//
//  Created by Jan-Peter Krämer on 01/01/16.
//  Copyright © 2016 Mic Pringle. All rights reserved.
//

import WatchKit
import ClockKit

class ComplicationDataSource: NSObject, CLKComplicationDataSource {
	func getSupportedTimeTravelDirectionsForComplication(complication: CLKComplication, withHandler handler: (CLKComplicationTimeTravelDirections) -> Void) {
		handler(.Forward)
	}
	
	func getCurrentTimelineEntryForComplication(complication: CLKComplication, withHandler handler: (CLKComplicationTimelineEntry?) -> Void) {
		switch complication.family {
		case .UtilitarianLarge:
			let template = CLKComplicationTemplateUtilitarianLargeFlat()

			let flight = Flight.allFlights().first!
			template.textProvider = CLKSimpleTextProvider(text: flight.origin + " " + flight.destination)
			
			let timelineEntry = CLKComplicationTimelineEntry(date: NSDate(), complicationTemplate: template)
			handler(timelineEntry)
		case .ModularSmall:
			let template = CLKComplicationTemplateModularSmallSimpleText()
			template.textProvider = CLKSimpleTextProvider(text: "Hi")
			let timelineEntry = CLKComplicationTimelineEntry(date: NSDate(), complicationTemplate: template)

			handler(timelineEntry)
		default:
			handler(nil)
		}
	}
	
	func getTimelineEntriesForComplication(complication: CLKComplication, afterDate date: NSDate, limit: Int, withHandler handler: ([CLKComplicationTimelineEntry]?) -> Void) {
		switch complication.family {
		case .UtilitarianLarge:
			let flights = Flight.allFlights()
			var entries: [CLKComplicationTimelineEntry] = []
			for i in 1...min(flights.count-1, limit) {
				let flight = flights[i]
				let template = CLKComplicationTemplateUtilitarianLargeFlat()
				
				template.textProvider = CLKSimpleTextProvider(text: flight.origin + " " + flight.destination)
				
				let timelineEntry = CLKComplicationTimelineEntry(date: date.dateByAddingTimeInterval(Double(60*60*i)), complicationTemplate: template)
				entries.append(timelineEntry)

			}
			handler(entries)
		default:
			handler(nil)
		}
	}
	
	func getPlaceholderTemplateForComplication(complication: CLKComplication, withHandler handler: (CLKComplicationTemplate?) -> Void) {
		switch complication.family {
		case .UtilitarianLarge:
			let template = CLKComplicationTemplateUtilitarianLargeFlat()
			template.textProvider = CLKSimpleTextProvider(text: "Hello World")
			handler(template)
		case .ModularSmall:
			let template = CLKComplicationTemplateModularSmallSimpleText()
			template.textProvider = CLKSimpleTextProvider(text: "Hi")
			handler(template)
		default:
			handler(nil)
		}
	}
	
	func getPrivacyBehaviorForComplication(complication: CLKComplication, withHandler handler: (CLKComplicationPrivacyBehavior) -> Void) {
		handler(.ShowOnLockScreen)
	}

}
